#include "Uefi.h"
//#include "Uefilib.h"
//#include "MemoryAllocationLib.h" //For AllocateZeroPool
//#include "Base.h" //For OFFSET_OF Macro
//#include "BaseMemoryLib.h"

#include "TPM20Info.h"
#include "ServerTPM2Tool.h"
#include "OutputFormat.h"
//#include "Debug.h"
#include "TPM20UI.h"
#include "TPM20CmdPack.h"
#include "SHA256.h"

extern EFI_SYSTEM_TABLE   *gST;

T2P_CONFIG_FILE 		sCfg;
CHAR16			sCfgFile[25] = L"Tpm2Prov.cfg";

UINT32 tpmOperation(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	EFI_STATUS      Status; 
	UINT32			errorCode = 0;
	/*
	T2T_SESSION_DEF_FILE 	sDef;
	T2T_NV_DEF_FILE 		iDef;
	T2T_POLICY_DEF_FILE 	pDef;
	
	T2T_POL_SET_FILE		pSet;
	T2T_K_DEF_FILE			kDef;
	*/
	
	/*
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;
	UINT8					rawData[1024];
	*/

	Print(L"--------Reading sCfg File------------\n\n"); 
	//if we fail to read the file, then we'll create a fresh one in memory and write it to disc at the end
	if (!readScfgFile(&sCfg, sCfgFile)) {
		ZeroMem( (UINT8*) &sCfg, sizeof(T2P_CONFIG_FILE) );
		initFileHeader( &sCfg.fHeader );
	}

#ifdef WIN32
	TPMLocality = sCfg.reserved;
#endif

	Print(L"TPM Operation: %s\n\n", operation[0]);	
	
	if (StrniCmp(operation[0], L"StartSession", 12) == 0 ) {
		
		errorCode = TPM2_StartSession(operation, numArgs, optionalArgs);
		
	} else if (StrniCmp(operation[0], L"SetActiveLocality", 17) == 0 ) {
		
		errorCode = TPM2_SetActiveLocality(operation, numArgs, optionalArgs);

	} else if (StrniCmp(operation[0], L"FlushSession", 12) == 0) {
		
		errorCode = TPM2_FlushSession(operation, numArgs, optionalArgs);
		
	} else if( StrniCmp(operation[0], L"PolicyRestart", 13) == 0) {
		
		errorCode = TPM2_PolicyRestart(operation, numArgs, optionalArgs);
		
	} else if( StrniCmp(operation[0], L"NvDefineSpace", 13) == 0 ) {

		errorCode = TPM2_NvDefineSpace(operation, numArgs, optionalArgs);
	
	} else if( StrniCmp(operation[0], L"NvWrite", 7) == 0 ) {
		
		errorCode = TPM2_NvWrite(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"NvVerifyDef", 11) == 0 ) {
	
		errorCode = TPM2_NvVerifyDef(operation, numArgs, optionalArgs);
		
	} else if( StrniCmp(operation[0], L"NvCompareData", 13) == 0 ) {
		
		errorCode = TPM2_NvCompareData(operation, numArgs, optionalArgs);
		
	} else if( StrniCmp(operation[0], L"NvReadPublic", 12) == 0 ) {
		
		errorCode = TPM2_NvReadPublic(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"ReadPublic", 10) == 0 ) {
		
		errorCode = TPM2_ReadPublic(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"NvRead", 6) == 0 ) {
	
		errorCode = TPM2_NvRead(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"NvUndefineSpace", 15) == 0 ) {
		
		errorCode = TPM2_NvUndefineSpace(operation, numArgs, optionalArgs);
	
	} else if( StrniCmp(operation[0], L"NvUndefineSpecial", 17) == 0 ) {
		
		errorCode = TPM2_NvUndefineSpecial(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"AssertPolicy", 12) == 0 ) {
		
		errorCode = TPM2_AssertPolicy(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"PolicyPhysicalPresence", 22) == 0 ) {

	} else if( StrniCmp(operation[0], L"PolicyAuthValue", 15) == 0 ) {
	
	} else if( StrniCmp(operation[0], L"PolicyPassword", 14) == 0 ) {
		
	} else if( StrniCmp(operation[0], L"ImportValue", 11) == 0 ) {
		
		errorCode = TPM2_ImportValue(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"ExportValue", 11) == 0 ) {
		
		errorCode = TPM2_ExportValue(operation, numArgs, optionalArgs);
		
	} else if( StrniCmp(operation[0], L"StorePolDigest", 14) == 0 ) {
		
		errorCode = TPM2_StorePolDigest(operation, numArgs, optionalArgs);
		
	} else if( StrniCmp(operation[0], L"SavePolDigestDLF", 16) == 0 ) {
		
		errorCode = TPM2_SavePolDigestDLF(operation, numArgs, optionalArgs);
			
	} else if( StrniCmp(operation[0], L"SavePolDigest", 13) == 0 ) {
		
		errorCode = TPM2_SavePolDigest(operation, numArgs, optionalArgs);
		
	} else if( StrniCmp(operation[0], L"SetPrimaryPolicy", 16) == 0 ) {
			
		errorCode = TPM2_SetPrimaryPolicy(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"PCRread", 7) == 0 ) {
		
		errorCode = TPM2_PCRread(operation, numArgs, optionalArgs);
			
	} else if( StrniCmp(operation[0], L"StartUpClear", 12) == 0 ) {

		errorCode = TPM_20_Startup( TPM_SU_CLEAR );

	} else if( StrniCmp(operation[0], L"StartUpState", 12) == 0 ) {

		errorCode = TPM_20_Startup( TPM_SU_STATE );

	} else if( StrniCmp(operation[0], L"ShutdownClear", 13) == 0 ) {

		errorCode = TPM_20_Shutdown( TPM_SU_CLEAR );

	} else if( StrniCmp(operation[0], L"ShutdownState", 13) == 0 ) {

		errorCode = TPM_20_Shutdown( TPM_SU_STATE );

	} else if( StrniCmp(operation[0], L"SelfTest", 8) == 0 ) {

		errorCode = TPM_20_SelfTest( FULL_SELFTEST );

	} else if( StrniCmp(operation[0], L"HierarchyChangeAuth", 19) == 0 ) {
			
		errorCode = TPM2_HierarchyChangeAuth(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"ClearOwner", 10) == 0 ) {
		
		errorCode = TPM2_ClearOwner(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"ClearControl", 12) == 0 ) {
		
		errorCode = TPM2_ClearControl(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"DaLockReset", 12) == 0 ) {
		
		errorCode = TPM2_DaLockReset(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"HashStart", 9) == 0 ) {
		
		errorCode = TPM2_HashStart(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"HashUpdate", 10) == 0 ) {
		
		errorCode = TPM2_HashUpdate(operation, numArgs, optionalArgs);	 

	} else if( StrniCmp(operation[0], L"HashComplete", 12) == 0 ) {
		
		errorCode = TPM2_HashComplete(operation, numArgs, optionalArgs);	 

	} else if( StrniCmp(operation[0], L"TPM2HMAC", 8) == 0 ) {
		
		errorCode = TPM2_TPM2HMAC(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"GetCapability", 13) == 0 ) {
		
		errorCode = TPM2_GetCapability(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"NVWriteLock", 11) == 0 ) {
	
		errorCode = TPM2_NVWriteLock(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"NVChangeAuth", 12) == 0 ) {
	
		errorCode = TPM2_NVChangeAuth(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"GetRandom", 9) == 0 ) {
	
		errorCode = TPM2_GetRandom(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"CreatePrimary", 13) == 0 ) {
	
		errorCode = TPM2_CreatePrimary(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"Create", 6) == 0 ) {
		
		errorCode = TPM2_Create(operation, numArgs, optionalArgs);
		
	} else if( StrniCmp(operation[0], L"STATUS", 6) == 0 ) {

		DisplayTPMStatus();

	} else if( StrniCmp(operation[0], L"LoadExternal", 12) == 0 ) {
		
		errorCode = TPM2_LoadExternal(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"Load", 4) == 0 ) {

		errorCode = TPM2_Load(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"Execute", 7) == 0 ) {
	
		errorCode = TPM2_Execute(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"SaveKey", 7) == 0 ) {
	
		errorCode = TPM2_SaveKey(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"LoadKey", 6) == 0 ) {
	
		errorCode = TPM2_LoadKey(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"LoadPublic", 10) == 0 ) {
	
		errorCode = TPM2_LoadPublic(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"LoadTemp", 8) == 0 ) {
	
		errorCode = TPM2_LoadTemp(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"HierarchyControl", 16) == 0 ) {
	
		errorCode = TPM2_HierarchyControl(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"DuplicateKey", 12) == 0 ) {
	
		errorCode = TPM2_Duplicate(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"PolicyPCR", 9) == 0 ) {
	
		errorCode = TPM2_PolicyPCR(operation, numArgs, optionalArgs);

	}  else if( StrniCmp(operation[0], L"CalcCpHash", 9) == 0 ) {
	
		errorCode = TPM2_CalcCpHash(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"PowerUp", 7) == 0 ) {
	
		errorCode = PlatformCommand( TPM_SIGNAL_POWER_ON );
		errorCode = PlatformCommand( TPM_SIGNAL_NV );
		TPM_20_Startup( TPM_SU_CLEAR ); 

	}  else if( StrniCmp(operation[0], L"PT2", 3) == 0 ) {
		
		errorCode = TPM2_PT2(operation, numArgs, optionalArgs);

	} else if( StrniCmp(operation[0], L"PowerDown", 9) == 0 ) {
	
		errorCode = PlatformCommand( TPM_SIGNAL_NV_OFF );
		errorCode = PlatformCommand( TPM_SIGNAL_POWER_OFF );

	} else {

		Print(L"Unrecognized Command\n");
		return UNSUPPORTED_OPERATION;
	}
	
	return errorCode;
}


BOOLEAN readSdefFile (T2T_SESSION_DEF_FILE *sDef, CHAR16 *sDefFile )
{
	//CHAR16			sDefFile[25] = L"PS_def.sDef";
	EFI_FILE_HANDLE	sDefFileHandle;
	FILE_HEADER 	sDefFileHeader;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
		
	//Read session def file
	Status = ShellOpenFileByName( sDefFile, &sDefFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n");
		return FALSE;
	} 
		
	//read the //FILE_HEADER structure from the file
	Status = FileHandleReadLine(sDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&sDefFileHandle, &sDefFileHeader);
		CopyMem( &sDef->fHeader, &sDefFileHeader, sizeof(FILE_HEADER) );
	}
		
	//read the //SDEF structure from the file
	Status = FileHandleReadLine(sDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//SDEF" ) == 0 ) {
		read_T2T_SESSION_DEF_FILE(&sDefFileHandle, sDef);
	}

	Status = ShellCloseFile(&sDefFileHandle);
	
	return TRUE;
}

BOOLEAN readIdefFile (T2T_NV_DEF_FILE *iDef, CHAR16 *iDefFile )
{

	//CHAR16			iDefFile[25] = L"PS_def.iDef";
	EFI_FILE_HANDLE	iDefFileHandle;
	UINT8			dummy[256];
	FILE_HEADER 	iDefFileHeader;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	//read idef file
	Status = ShellOpenFileByName( iDefFile, &iDefFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n");
		return FALSE;
	} 
		
	//read the //FILE_HEADER structure from the file
	Status = FileHandleReadLine(iDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print( L"readLine status: %x, ASCII: %x \n", Status, ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&iDefFileHandle, &iDefFileHeader);
		CopyMem( &iDef->fHeader, &iDefFileHeader, sizeof(FILE_HEADER) );
	}
		
	//read the //IDEF structure from the file
	Status = FileHandleReadLine(iDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//IDEF" ) == 0 ) {
		read_T2T_NV_DEF_FILE(&iDefFileHandle, iDef);
	}
	
	Status = ShellCloseFile(&iDefFileHandle);
		
	return TRUE;
}

BOOLEAN readPdefFile (T2T_POLICY_DEF_FILE *pDef, CHAR16 *pDefFile )
{

	//CHAR16			iDefFile[25] = L"PS_def.iDef";
	EFI_FILE_HANDLE	pDefFileHandle;
	FILE_HEADER 	pDefFileHeader;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	//read idef file
	Status = ShellOpenFileByName( pDefFile, &pDefFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n");
		return FALSE;
	} 
		
	//read the //SDEF structure from the file
	Status = FileHandleReadLine(pDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&pDefFileHandle, &pDefFileHeader);
		CopyMem( &pDef->fHeader, &pDefFileHeader, sizeof(FILE_HEADER) );
	}
		
	//read the //IDEF structure from the file
	Status = FileHandleReadLine(pDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//PDEF" ) == 0 ) {
		read_T2T_POLICY_DEF_FILE(&pDefFileHandle, pDef);
	}
	
	Status = ShellCloseFile(&pDefFileHandle);
		
	return TRUE;
}

BOOLEAN readDigestListFile (T2T_DIGEST_LIST_FILE *digestListFile, CHAR16 *digestFile )
{

	//CHAR16			iDefFile[25] = L"PS_def.iDef";
	EFI_FILE_HANDLE	pDlfFileHandle;
	FILE_HEADER 	pDlfFileHeader;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	//read idef file
	Status = ShellOpenFileByName( digestFile, &pDlfFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n");
		return FALSE;
	} 
		
	//read the //SDEF structure from the file
	Status = FileHandleReadLine(pDlfFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&pDlfFileHandle, &pDlfFileHeader);
		CopyMem( &digestListFile->fHeader, &pDlfFileHeader, sizeof(FILE_HEADER) );
	}
		
	//read the //IDEF structure from the file
	Status = FileHandleReadLine(pDlfFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//DLF" ) == 0 ) {
		read_T2T_DIGEST_LIST_FILE(&pDlfFileHandle, digestListFile);
	}
	
	Status = ShellCloseFile(&pDlfFileHandle);
		
	return TRUE;
}

BOOLEAN readScfgFile (T2P_CONFIG_FILE *sCfg, CHAR16 *sCfgFile )
{
	//CHAR16			sCfgFile[25] = L"Tpm2Prov.cfg";
	FILE_HEADER 	sCfgFileHeader;
	EFI_FILE_HANDLE	sCfgFileHandle;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	Status = ShellOpenFileByName( sCfgFile, &sCfgFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n", sCfgFile);
		return FALSE;
	}
	 
	//read the //file header from the file
	Status = FileHandleReadLine(sCfgFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&sCfgFileHandle, &sCfgFileHeader);
		CopyMem( &sCfg->fHeader, &sCfgFileHeader, sizeof(FILE_HEADER) );
	}

	//if the version is not equal to the current version, abort the read. Later we'll make fresh version of the file
	if ( sCfg->fHeader.ToolVersion != TPM2_FACT_PROV_TOOL_MAJOR_VERSION ) {
		return FALSE;
	}

	//read the //SCFG structure from the file
	Status = FileHandleReadLine(sCfgFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	//Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//SCFG" ) == 0 ) {
		read_T2P_CONFIG_FILE(&sCfgFileHandle, sCfg);
	}
	
	Status = ShellCloseFile(&sCfgFileHandle);
	return TRUE;
}

BOOLEAN readDatFile (UINT8 *rawData, UINT64 *dataSize, CHAR16 *dataFile) 
{
	EFI_FILE_HANDLE	dataFileHandle;
	UINT64			Attributes = 0;
	UINT32			u32dataSize;
	EFI_STATUS      Status; 
	
	
	Status = ShellOpenFileByName( dataFile, &dataFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n", dataFile);
		return FALSE;
	}
	
	Status = ShellGetFileSize( dataFileHandle, dataSize );
	//if(Status != EFI_SUCCESS){
	//	Print(L"ERROR: cannot read file size %s\n", dataFile);
	//}
	u32dataSize = (UINT32) *dataSize;
	if (u32dataSize != 0) {
		Status = ShellReadFile( dataFileHandle, (unsigned int*)&u32dataSize, rawData );
		if(Status != EFI_SUCCESS){
			Print(L"ERROR: cannot read file %s\n", dataFile);
		}
	}
	
	Status = ShellCloseFile(&dataFileHandle);
	return TRUE;
}

BOOLEAN writeDatFile (UINT8 *rawData, UINT64 *dataSize, CHAR16 *dataFile) 
{
	EFI_FILE_HANDLE	dataFileHandle;
	UINT64			Attributes = 0;
	UINT32			u32dataSize = 0;
	EFI_STATUS      Status; 
	
	
	Status = ShellOpenFileByName( dataFile, &dataFileHandle, EFI_FILE_MODE_READ | EFI_FILE_MODE_WRITE | EFI_FILE_MODE_CREATE, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n", dataFile);
		return FALSE;
	}
	
	u32dataSize = (UINT32)*dataSize;
	Status = ShellWriteFile(dataFileHandle, (unsigned int*)&u32dataSize, rawData);

	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot write file %s\n", dataFile);
	}
	
	Status = ShellCloseFile(&dataFileHandle);
	return TRUE;
}

BOOLEAN readPsetFile (T2T_POL_SET_FILE *pSet, CHAR16 *pSetFile )
{
	FILE_HEADER 	pSetFileHeader;
	EFI_FILE_HANDLE	pSetFileHandle;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	Status = ShellOpenFileByName( pSetFile, &pSetFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n", pSetFile);
		return FALSE;
	}
	 
	//read the //file header from the file
	Status = FileHandleReadLine(pSetFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&pSetFileHandle, &pSetFileHeader);
		CopyMem( &pSet->fHeader, &pSetFileHeader, sizeof(FILE_HEADER) );
	}
	
	//read the //pSet structure from the file
	Status = FileHandleReadLine(pSetFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//PSET" ) == 0 ) {
		read_T2T_POL_SET_FILE(&pSetFileHandle, pSet);
	}
	
	Status = ShellCloseFile(&pSetFileHandle);
	return TRUE;
}

BOOLEAN readKdefFile (T2T_K_DEF_FILE *kDef, CHAR16 *pKdefFile )
{
	FILE_HEADER 	kDefFileHeader;
	EFI_FILE_HANDLE	kDefFileHandle;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	Status = ShellOpenFileByName( pKdefFile, &kDefFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n", pKdefFile);
		return FALSE;
	}
	 
	//read the //file header from the file
	Status = FileHandleReadLine(kDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&kDefFileHandle, &kDefFileHeader);
		CopyMem( &kDef->fHeader, &kDefFileHeader, sizeof(FILE_HEADER) );
	}
	
	//read the //pSet structure from the file
	Status = FileHandleReadLine(kDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//KDEF" ) == 0 ) {
		read_T2T_K_DEF_FILE(&kDefFileHandle, kDef);
	}
	
	Status = ShellCloseFile(&kDefFileHandle);
	return TRUE;
}

BOOLEAN readCdefFile (T2T_CDEF_FILE *cDef, CHAR16 *pCdefFile )
{
	FILE_HEADER 	cDefFileHeader;
	EFI_FILE_HANDLE	cDefFileHandle;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	Status = ShellOpenFileByName( pCdefFile, &cDefFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n", pCdefFile);
		return FALSE;
	}
	 
	//read the //file header from the file
	Status = FileHandleReadLine(cDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&cDefFileHandle, &cDefFileHeader);
		CopyMem( &cDef->fHeader, &cDefFileHeader, sizeof(FILE_HEADER) );
	}
	
	//read the //pSet structure from the file
	Status = FileHandleReadLine(cDefFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//CDEF" ) == 0 ) {
		read_T2T_CDEF_FILE(&cDefFileHandle, cDef);
	}
	
	Status = ShellCloseFile(&cDefFileHandle);
	return TRUE;
}

BOOLEAN readSobjFile (T2T_SOBJ_FILE *sObj, CHAR16 *pSobjFile )
{
	FILE_HEADER 	sObjFileHeader;
	EFI_FILE_HANDLE	sObjFileHandle;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	Status = ShellOpenFileByName( pSobjFile, &sObjFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n", pSobjFile);
		return FALSE;
	}
	 
	//read the //file header from the file
	Status = FileHandleReadLine(sObjFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&sObjFileHandle, &sObjFileHeader);
		CopyMem( &sObj->fHeader, &sObjFileHeader, sizeof(FILE_HEADER) );
	}
	
	//read the //pSet structure from the file
	Status = FileHandleReadLine(sObjFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//SOBJ" ) == 0 ) {
		read_T2P_SOBJ(&sObjFileHandle, sObj);
	}
	
	Status = ShellCloseFile(&sObjFileHandle);
	return TRUE;
}

BOOLEAN readDdupFile (T2T_DUP_FILE *dDup, CHAR16 *pDdupFile )
{
	FILE_HEADER 	dDupFileHeader;
	EFI_FILE_HANDLE	dDupFileHandle;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	UINTN 			size = 256;
	BOOLEAN 		ascii = FALSE;
	
	Status = ShellOpenFileByName( pDdupFile, &dDupFileHandle, EFI_FILE_MODE_READ, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open file %s\n", pDdupFile);
		return FALSE;
	}
	 
	//read the //file header from the file
	Status = FileHandleReadLine(dDupFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//FILE_HEADER" ) == 0 ) {
		read_FILEHEADER(&dDupFileHandle, &dDupFileHeader);
		CopyMem( &dDup->fHeader, &dDupFileHeader, sizeof(FILE_HEADER) );
	}
	
	//read the //pSet structure from the file
	Status = FileHandleReadLine(dDupFileHandle, &readBuffer, &size, /*IN BOOLEAN Truncate*/ TRUE, /*IN OUT BOOLEAN *Ascii*/ &ascii);
	Print(L"Structure: %s\n", readBuffer);
	if( StrCmp( readBuffer, L"//T2T_DUP_FILE" ) == 0 ) {
		read_T2P_SOBJ(&dDupFileHandle, dDup);
	}
	
	Status = ShellCloseFile(&dDupFileHandle);
	return TRUE;
}

BOOLEAN updateScfgFile (T2P_CONFIG_FILE *sCfg, CHAR16 *sCfgFile )
{
	//CHAR16			sCfgFile[25] = L"Tpm2Prov.cfg";
	FILE_HEADER 	sCfgFileHeader;
	EFI_FILE_HANDLE	sCfgFileHandle;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	
	//open test config file
	Status = ShellOpenFileByName( sCfgFile, &sCfgFileHandle, EFI_FILE_MODE_READ | EFI_FILE_MODE_WRITE | EFI_FILE_MODE_CREATE, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open config file %s\n");
		return FALSE;
	}
	
	//update the file
	update_T2P_CONFIG_FILE(&sCfgFileHandle, sCfg);
	//close that shit
	Status = ShellCloseFile(&sCfgFileHandle);
		
	return TRUE;
}

BOOLEAN updateSobjFile (T2T_SOBJ_FILE *sObj, CHAR16 *sObjFile )
{
	//CHAR16			sCfgFile[25] = L"Tpm2Prov.cfg";
	FILE_HEADER 	sObjFileHeader;
	EFI_FILE_HANDLE	sObjFileHandle;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	
	//open test config file
	Status = ShellOpenFileByName( sObjFile, &sObjFileHandle, EFI_FILE_MODE_READ | EFI_FILE_MODE_WRITE | EFI_FILE_MODE_CREATE, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open save key file %s\n");
		return FALSE;
	}
	
	//update the file
	update_T2P_SOBJ_FILE(&sObjFileHandle, sObj);
	//close that shit
	Status = ShellCloseFile(&sObjFileHandle);
		
	return TRUE;
}

BOOLEAN update_DIGEST_LIST_FILE (T2T_DIGEST_LIST_FILE *digestListFile, CHAR16 *digestFile )
{
	//CHAR16			sCfgFile[25] = L"Tpm2Prov.cfg";
	FILE_HEADER 	digestFileHeader;
	EFI_FILE_HANDLE	digestFileHandle;
	UINT64			Attributes = 0;
	EFI_STATUS      Status; 
	CHAR16 			readBuffer[256];
	
	//open test config file
	Status = ShellOpenFileByName( digestFile, &digestFileHandle, EFI_FILE_MODE_READ | EFI_FILE_MODE_WRITE | EFI_FILE_MODE_CREATE, Attributes );
	if(Status != EFI_SUCCESS){
		Print(L"ERROR: cannot open digest list file %s\n");
		return FALSE;
	}
	
	//update the file
	update_T2T_DIGEST_LIST_FILE(&digestFileHandle, digestListFile);
	//close that shit
	
	Status = ShellCloseFile(&digestFileHandle);
	
	return TRUE;
}

UINT32 TPM2_StartSession (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_SESSION_DEF_FILE 	sDef;

	UINT64			sessionNumber = 0;	
			
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading sDef File------------\n\n"); 
	readSdefFile(&sDef, operation[1]);
	
	Print(L"--------TPM 2.0 Start Auth Session---\n\n"); 
		
	if ( sDef.sessionType != 0xF0 ) {

		packStartAuthSession(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sDef, &sCfg);
		
		DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
		DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
		DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
		DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		Print(L"before TPM_20_StartAuthSession\n");
		if ( TPM_20_StartAuthSession(&packedCmd, &sCfg.session[sessionNumber].sessionHandle, &sCfg.session[sessionNumber].lastNonceTpm.size, &sCfg.session[sessionNumber].lastNonceTpm.buffer ) == 0 ) {
			sCfg.session[sessionNumber].sessionType = sDef.sessionType;
			sCfg.session[sessionNumber].tpmKey = TPM_RH_NULL;
			sCfg.session[sessionNumber].bind = TPM_RH_NULL;
			sCfg.session[sessionNumber].nonceSize = 0x20;
			sCfg.session[sessionNumber].nonceType = 0xA5;
			Print(L"authSessionHandle: 0x%08x\n", sCfg.session[sessionNumber].sessionHandle);
			updateScfgFile( &sCfg, sCfgFile ); 

			return 0;
		}
		
	} else {
		sCfg.session[sessionNumber].sessionHandle = TPM_RS_PW;

		sCfg.session[sessionNumber].sessionType = sDef.sessionType;
		sCfg.session[sessionNumber].tpmKey = TPM_RH_NULL;
		sCfg.session[sessionNumber].bind = TPM_RH_NULL;
		sCfg.session[sessionNumber].nonceSize = 0;
		sCfg.session[sessionNumber].nonceType = 0x0;
		sCfg.session[sessionNumber].authValue.size = sDef.authValue.size;
		sCfg.session[sessionNumber].authValue.buffer.size = sDef.authValue.size;
		CopyMem( &sCfg.session[sessionNumber].authValue.buffer.buffer, &sDef.authValue.buffer.buffer, sDef.authValue.buffer.size );
		
		Print(L"authSessionHandle: 0x%08x\n", sCfg.session[sessionNumber].sessionHandle);
		updateScfgFile( &sCfg, sCfgFile ); 
		return 0;

	}
	//TPM_RS_PW
	//Print(L"nonce size: 0x%08x\n", sCfg.session[sessionNumber].lastNonceTpm.size);
	//DumpHexValue(L"TPM Nonce[32]:", (UINT8 *)&sCfg.session[sessionNumber].lastNonceTpm.buffer, 32);
		
	//copy the session memory to the config file
	//CopyMem( &sCfg.session[sessionNumber].tpmKey, &sDef.tpmKey, sizeof(T2T_SESSION_DEF_FILE) - sizeof(FILE_HEADER) );

	return -1;
}

UINT32 TPM2_SetActiveLocality(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			locality = 0;	

	Print(L"--------TPM 2.0 Save Context------------------\n\n"); 
	ShellConvertStringToUint64( operation[1], &locality, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	sCfg.reserved = locality;
	updateScfgFile( &sCfg, sCfgFile ); 

	return 0;
}

UINT32 TPM2_FlushSession (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;
	UINT64			sessionNumber = 0;	
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	
	Print(L"--------TPM 2.0 Flush Context------------------\n\n"); 
		
	if ( TPM_20_FlushContext( sCfg.session[sessionNumber].sessionHandle ) == 0 ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_PolicyRestart (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			sessionNumber = 0;	
	CHAR16			sCfgFile[25] = L"Tpm2Prov.cfg";
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	packPolicyRestart(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, sessionNumber);

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	Print(L"--------TPM 2.0 Policy Restart------------------\n\n"); 
			
	if ( TPM_20_SendGenericCommand( &packedCmd ) == 0 ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_NvDefineSpace (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE 		iDef;

	UINT64			sessionNumber = 0;	
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading iDef File------------\n\n"); 
	readIdefFile(&iDef, operation[1]);
		
	Print(L"--------TPM 2.0 Index Define--------------\n\n");
	packIndexDefine(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &iDef, &sCfg, (UINT8)sessionNumber);
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == 0 ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_NvWrite (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE 		iDef;

	UINT64			sessionNumber = 0;	
	UINT32			handle0 = 0;
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading iDef File------------\n\n"); 
	readIdefFile(&iDef, operation[1]);
		
	if( StrniCmp(operation[3], L"PH", 2) == 0 ) {
		handle0 = TPM_RH_PLATFORM;
	} else if( StrniCmp(operation[3], L"SH", 2) == 0 ) {
		handle0 = TPM_RH_OWNER ;
	} else {
		handle0 = iDef.publicInfo.nvPublic.nvIndex;
	}

	Print(L"--------TPM 2.0 Index Write--------------\n\n");
		
	packIndexWrite(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &iDef, &sCfg, (UINT8)sessionNumber, handle0);
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if( TPM_20_NV_Write( &packedCmd ) ==0 ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_NvVerifyDef (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE 		iDef;

	FSR2B_NV_PUBLIC nvPublic1;
	TPM2B_NAME name;
	UINT8 indexData[256];
	UINT8	returnCode = 0;
		
	Print(L"--------Reading iDef File------------\n\n"); 
	readIdefFile(&iDef, operation[1]);
		
	Print(L"--------TPM 2.0 Index Read Public--------------\n\n");
		
	if ( TPM_20_NV_ReadPublic(iDef.publicInfo.nvPublic.nvIndex, 100, &nvPublic1, &name, TRUE) == 0 ) {

		returnCode = TPM_20_NV_Verify_Def( &iDef.publicInfo, &nvPublic1, iDef.verify, &iDef.auth, iDef.attibuteMask);

		if (returnCode != 0) {
			//if the index definitions aren't identicle, perform the attribute mask
			//the attribute mask will tell us if the differences are acceptable.

			UINT32 *attributes0 = &iDef.publicInfo.nvPublic.attributes;
			UINT32 *attributes1 = &nvPublic1.nvPublic.attributes;
			UINT32 criticalAttributes0 = iDef.attibuteMask & (*attributes0);
			UINT32 criticalAttributes1 = iDef.attibuteMask & (*attributes1);
			if( criticalAttributes0 != criticalAttributes1 ) {
				Print(L"SDEF masked atributes: 0x%08x\n", criticalAttributes0);
				Print(L"Nv Def masked atributes: 0x%08x\n", criticalAttributes1);
				return returnCode;
			}
		} 

		return returnCode;
	}
		
	return 0xFF;
}

UINT32 TPM2_NvCompareData (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE 		iDef;

	UINT64			sessionNumber = 0;
	UINT8			indexData[256];
	UINT32			handle0 = 0;
	
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	Print(L"--------Reading iDef File------------\n"); 
	readIdefFile(&iDef, operation[1]);
	
	if (StrniCmp(operation[3], L"PH", 2) == 0) {
		handle0 = TPM_RH_PLATFORM;
	}
	else if (StrniCmp(operation[3], L"SH", 2) == 0) {
		handle0 = TPM_RH_OWNER;
	}
	else {
		handle0 = iDef.publicInfo.nvPublic.nvIndex;
	}

	Print(L"--------TPM 2.0 Index Read--------------\n");
		
	packNvRead(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &iDef, &sCfg, (UINT8)sessionNumber, handle0);

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	Print(L"--------TPM 2.0 Index Read--------------\n");
	if ( TPM_20_NV_Read( &packedCmd, indexData, iDef.publicInfo.nvPublic.dataSize, TRUE) /*TPM_20_NV_Read(iDef.publicInfo.nvPublic.nvIndex, indexData, iDef.publicInfo.nvPublic.dataSize, TRUE)*/ != 0 ) {
		return -1;
	}
		
	DumpHexValue (L"Idef Index Data:", (UINT8 *) iDef.dataSource.buffer.buffer, iDef.publicInfo.nvPublic.dataSize);
	DumpHexValue (L"NV Index Data:", (UINT8 *) indexData, iDef.publicInfo.nvPublic.dataSize);
	if ( CompareMem( iDef.dataSource.buffer.buffer, indexData, iDef.publicInfo.nvPublic.dataSize ) == 0 ) {
		return 0;
	} else {
		Print("ERROR: NV index data mismatch\n");
	}

	return -1;
}

UINT32 TPM2_NvReadPublic (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE 		iDef;

	FSR2B_NV_PUBLIC nvPublic;
	TPM2B_NAME name;
	UINT64			outNameIDX = 0;
		
	Print(L"--------Reading iDef File------------\n"); 
	readIdefFile(&iDef, operation[1]);
		
	Print(L"--------TPM 2.0 Index Read Public--------------\n");
		
	if ( TPM_20_NV_ReadPublic(iDef.publicInfo.nvPublic.nvIndex, 100, &nvPublic, &name, TRUE) == 0 ) {

		if ( numArgs > 1 ) {
			ShellConvertStringToUint64( operation[2], &outNameIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			sCfg.digest[outNameIDX].size = name.size;
			CopyMem( &sCfg.digest[outNameIDX].buffer, &name.name, name.size );
		}

		return 0;
	}

	return INDEX_DOESNT_EXIST;
}

UINT32 TPM2_ReadPublic (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;
	
	UINT32			objectHandle = 0;
	TPM2B_PUBLIC	publicInfo; 
	TPM2B_NAME		name;
	TPM2B_NAME		qualifiedName;
	UINT64			outNameIDX = 0;

	ShellConvertStringToUint64( operation[1], &objectHandle, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------TPM 2.0 Read Public--------------\n");
		
	if ( TPM_20_ReadPublic(objectHandle, &publicInfo, &name, &qualifiedName, TRUE) == 0 ) {

		if ( numArgs > 1 ) {
			ShellConvertStringToUint64( operation[2], &outNameIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			sCfg.digest[outNameIDX].size = name.size;
			CopyMem( &sCfg.digest[outNameIDX].buffer, &name.name, name.size );
		}
		return 0;
	}

	return -1;
}

UINT32 TPM2_NvRead (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE 		iDef;

	UINT64			sessionNumber = 0;
	UINT8			indexData[256];
	UINT32			handle0 = 0;
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	Print(L"--------Reading iDef File------------\n"); 
	readIdefFile(&iDef, operation[1]);
	
	if (StrniCmp(operation[3], L"PH", 2) == 0) {
		handle0 = TPM_RH_PLATFORM;
	}
	else if (StrniCmp(operation[3], L"SH", 2) == 0) {
		handle0 = TPM_RH_OWNER;
	}
	else {
		handle0 = iDef.publicInfo.nvPublic.nvIndex;
	}

	Print(L"--------TPM 2.0 Index Read--------------\n");
		
	packNvRead(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &iDef, &sCfg, (UINT8)sessionNumber, handle0);

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	if ( TPM_20_NV_Read( &packedCmd, indexData, iDef.dataSource.buffer.size, TRUE) == 0 ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_NvUndefineSpace (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE 		iDef;

	UINT64			sessionNumber = 0;
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading iDef File------------\n"); 
	readIdefFile(&iDef, operation[1]);
		
	Print(L"--------TPM 2.0 Index Delete--------------\n");
	packIndexDelete(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &iDef, &sCfg, (UINT8)sessionNumber);
	
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	if ( TPM_20_NV_Delete_Index( &packedCmd ) == 0 ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_NvUndefineSpecial (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE 		iDef;

	UINT64			sessionNumber = 0;
	UINT64			sessionNumber2 = 0;
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[3], &sessionNumber2, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading iDef File------------\n"); 
	if (!readIdefFile(&iDef, operation[1])) {
		return -1;
	}
	
	packIndexDeleteSpecial(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &iDef, &sCfg, (UINT8) sessionNumber, (UINT8) sessionNumber2);

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	if ( TPM_20_SendGenericCommand( &packedCmd ) == 0 ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_AssertPolicy (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_POLICY_DEF_FILE 	pDef;

	UINT64			sessionNumber = 0;
	UINT64			sessionNumber2 = 0;
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[3], &sessionNumber2, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading pDef File------------\n"); 
	if (!readPdefFile(&pDef, operation[1])) {
		return -1;
	}
		
	Print(L"sessionNumber2: %d\n", sessionNumber2);
	assertPolicy(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &pDef, &sCfg, (UINT8) sessionNumber, (UINT8) sessionNumber2);

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == 0 ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_ImportValue (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT8			rawData[1024];

	UINT64 			dataSize = 0;
	UINT64			cfgDigestIndexNumber = 0;
		
	//data size
	ShellConvertStringToUint64( operation[3], &cfgDigestIndexNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading data File------------\n"); 
	readDatFile((UINT8*)&rawData, &dataSize, operation[1]);
		
	DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);	
		
	if( StrniCmp(operation[2], L"Auth", 4) == 0 ) {
		CopyMem( &sCfg.authValue[cfgDigestIndexNumber].size, &dataSize, sizeof( UINT16 ) );
		CopyMem( &sCfg.authValue[cfgDigestIndexNumber].buffer, &rawData, dataSize );

	} else if( StrniCmp(operation[2], L"Digest", 6) == 0 ) {
		CopyMem( &sCfg.digest[cfgDigestIndexNumber].size, &dataSize, sizeof( UINT16 ) );
		CopyMem( &sCfg.digest[cfgDigestIndexNumber].buffer, &rawData, dataSize );

	} else if( StrniCmp(operation[2], L"Key", 3) == 0 ) {
		CopyMem( &sCfg.key[cfgDigestIndexNumber].size, &dataSize, sizeof( UINT16 ) );
		CopyMem( &sCfg.key[cfgDigestIndexNumber].buffer, &rawData, dataSize );

	} else if( StrniCmp(operation[2], L"Data", 4) == 0 ) {
		CopyMem( &sCfg.data[cfgDigestIndexNumber].size, &dataSize, sizeof( UINT16 ) );
		CopyMem( &sCfg.data[cfgDigestIndexNumber].buffer, &rawData, dataSize );

	} else {
		Print(L"Error: Unknown Import Type - Please use Auth, Digest, Key, or Data\n");
		return -1;
	}
	
	Print(L"--------TPM 2.0 Updating Config File------\n"); 
	updateScfgFile( &sCfg, sCfgFile ); 

	return 0;
}

UINT32 TPM2_ExportValue (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT8			rawData[1024];

	UINT64 			dataSize = 0;
	UINT64			cfgDigestIndexNumber = 0;
			
	//data size
	ShellConvertStringToUint64( operation[2], &cfgDigestIndexNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	if( StrCmp(operation[1], L"Auth") == 0 ) {
		CopyMem( &dataSize, &sCfg.authValue[cfgDigestIndexNumber].size, sizeof( UINT16 ) );
		CopyMem( &rawData, &sCfg.authValue[cfgDigestIndexNumber].buffer,  dataSize );

	} else if( StrCmp(operation[1], L"Digest") == 0 ) {
		CopyMem( &dataSize, &sCfg.digest[cfgDigestIndexNumber].size, sizeof( UINT16 ) );
		CopyMem( &rawData, &sCfg.digest[cfgDigestIndexNumber].buffer,  dataSize );

	} else if( StrCmp(operation[1], L"Key") == 0 ) {
		CopyMem( &dataSize, &sCfg.key[cfgDigestIndexNumber].size, sizeof( UINT16 ) );
		CopyMem( &rawData, &sCfg.key[cfgDigestIndexNumber].buffer,  dataSize );

	} else if( StrCmp(operation[1], L"Data") == 0 ) {
		CopyMem( &dataSize, &sCfg.data[cfgDigestIndexNumber].size, sizeof( UINT16 ) );
		CopyMem( &rawData, &sCfg.data[cfgDigestIndexNumber].buffer,  dataSize );

	} else {
		Print(L"Error: Unknown Export Type - Please use Auth, Digest, Key, or Data\n");
		return -1;
	}

	DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);

	Print(L"--------Writing data File------------\n"); 
	writeDatFile((UINT8*)&rawData, &dataSize, operation[3]);

	return 0;
}

UINT32 TPM2_StorePolDigest(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_SESSION_DEF_FILE 	sDef;

	UINT64			sessionNumber = 0;
	UINT64			dlfIndexNumber = 0;
	UINT16			digestSize = 0;
	UINT8 			digest[64];
		
	CHAR16			*token = NULL; 
	UINT32			length = 0;
	T2T_DIGEST_LIST_FILE 	digestListFile;
		
	//session number to issue the command
	ShellConvertStringToUint64( operation[1], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	//index number to store the digest in the digeslt list file
	ShellConvertStringToUint64( operation[2], &dlfIndexNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			
	packPolicyDigest(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sDef, &sCfg, sessionNumber);
		
	Print(L"--------TPM 2.0 Policy Get Digest------\n"); 
	if (  TPM_20_PolicyGetDigest( &packedCmd, (UINT8*)&digest, &digestSize ) == TCG_OK ) {
			
		CopyMem( &sCfg.digest[dlfIndexNumber].size, &digestSize, sizeof( UINT16 ) );
		CopyMem( &sCfg.digest[dlfIndexNumber].buffer, &digest, digestSize );
		Print(L"--------TPM 2.0 Updating Config File------\n"); 
		updateScfgFile( &sCfg, sCfgFile ); 
		return 0;
	}

	return -1;
}

UINT32 TPM2_SavePolDigestDLF(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_SESSION_DEF_FILE 	sDef;

	UINT64			sessionNumber = 0;
	UINT64			dlfIndexNumber = 0;
	UINT16			digestSize = 0;
	UINT8 			digest[64];
	CHAR16			dlfFile[25];
		
	CHAR16			*token = NULL; 
	UINT32			length = 0;
	T2T_DIGEST_LIST_FILE 	digestListFile;
		
	//session number to issue the command
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	//index number to store the digest in the digeslt list file
	ShellConvertStringToUint64( operation[3], &dlfIndexNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			
	packPolicyDigest(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sDef, &sCfg, sessionNumber);
		
	Print(L"--------TPM 2.0 Policy Get Digest------\n"); 
	if ( TPM_20_PolicyGetDigest( &packedCmd, (UINT8*)&digest, &digestSize ) == TCG_OK ) {
		
		Print(L"operation[1]: %s\n", operation[1]);
		length = StrLen(operation[1]);
		StrnCpy(dlfFile, operation[1], StrLen(operation[1]) );
		dlfFile[length] = CHAR_NULL;
		Print(L"dlfFile: %s\n", dlfFile);
		
		token = mystrtok(operation[1], L".");
		Print(L"token: %s\n", token);
		token = mystrtok(NULL, L".");
		Print(L"token: %s\n", token);		
		if ( StrCmp(token, L"dlf") == 0 || StrCmp(token, L"DLF") == 0 ) {
			Print(L"--------TPM 2.0 Reading Digest List File------\n"); 
			readDigestListFile( &digestListFile, dlfFile );
			CopyMem( &digestListFile.digest[dlfIndexNumber].size, &digestSize, sizeof( UINT16 ) );
			CopyMem( &digestListFile.digest[dlfIndexNumber].buffer.size, &digestSize, sizeof( UINT16 ) );
			CopyMem( &digestListFile.digest[dlfIndexNumber].buffer.buffer, &digest, digestSize );
			Print(L"--------TPM 2.0 Updating Digest List File------\n"); 
			update_DIGEST_LIST_FILE( &digestListFile, dlfFile );
		} else if ( StrCmp(token, L"cfg") == 0 || StrCmp(token, L"CFG") == 0 ) {
			
			CopyMem( &sCfg.digest[dlfIndexNumber].size, &digestSize, sizeof( UINT16 ) );
			CopyMem( &sCfg.digest[dlfIndexNumber].buffer, &digest, digestSize );
			Print(L"--------TPM 2.0 Updating Config File------\n"); 
			updateScfgFile( &sCfg, sCfgFile ); 
		}

		return 0;
	}

	return -1;
}

UINT32 TPM2_SavePolDigest(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_SESSION_DEF_FILE 	sDef;

	UINT64			sessionNumber = 0;
	UINT64			dlfIndexNumber = 0;
	UINT16			digestSize = 0;
	UINT8 			digest[64];
	CHAR16			dlfFile[25];
		
	CHAR16			*token = NULL; 
	UINT32			length = 0;
	T2T_DIGEST_LIST_FILE 	digestListFile;
		
	//session number to issue the command
	ShellConvertStringToUint64( operation[1], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			
	packPolicyDigest(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sDef, &sCfg, sessionNumber);
		
	Print(L"--------TPM 2.0 Policy Get Digest------\n"); 
	if ( TPM_20_PolicyGetDigest( &packedCmd, (UINT8*)&digest, &digestSize ) == TCG_OK ) {

		Print(L"operation[2]: %s\n", operation[2]);
		
		DumpHexValue(L"rawData:", (UINT8 *)&digest, digestSize);

		Print(L"--------Writing data File------------\n"); 
		writeDatFile((UINT8*)&digest, (UINT64*)&digestSize, operation[2]);

		return 0;
	}

	return -1;
}

UINT32 TPM2_SetPrimaryPolicy(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_POL_SET_FILE		pSet;

	UINT64			sessionNumber = 0;	
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	
	Print(L"--------Reading pSef File------------\n"); 
	readPsetFile(&pSet, operation[1]);		
		
	packSetPrimaryPolicy(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &pSet, &sCfg, (UINT8) sessionNumber);

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_PCRread(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT16 tpmAlgId = 0x0004;
	UINT8 PCRSelect0 = 0xFF;
	UINT8 PCRSelect1 = 0xFF; 
	UINT8 PCRSelect2 = 0xFF;

	ShellConvertStringToUint64( operation[1], (UINT64*)&tpmAlgId, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	Print(L"************Reading TPM Platform Configuration Registers ****\n");
	TPM_20_ReadPCR( tpmAlgId, PCRSelect0, 0, 0 );
	TPM_20_ReadPCR( tpmAlgId, 0, PCRSelect1, 0 );
	TPM_20_ReadPCR( tpmAlgId, 0, 0, PCRSelect2 );
	Print(L"\n");

	return -1;
}

UINT32 TPM2_HierarchyChangeAuth(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			sessionNumber = 0;
	UINT32			hierarchy = 0;
			
	if( StrCmp(operation[1], L"PH") == 0 ) {
		hierarchy = TPM_RH_PLATFORM;
	} else if( StrCmp(operation[1], L"SH") == 0 ) {
		hierarchy = TPM_RH_OWNER ;
	} else if( StrCmp(operation[1], L"EH") == 0 ) {
		hierarchy = TPM_RH_ENDORSEMENT;
	} else {
		Print(L"Error: Unknown Hierarchy - Please use PH, SH, or EH\n");
	}

	ShellConvertStringToUint64( operation[3], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	packHierarchyChangeAuth(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT8) sessionNumber, hierarchy, operation[2] );
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_ClearOwner(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			sessionNumber = 0;
		
	ShellConvertStringToUint64( operation[1], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			
	packTPM2Clear(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT8) sessionNumber );
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_ClearControl(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			sessionNumber = 0;
	UINT64			OwnerClearDisable = 0;
	ShellConvertStringToUint64( operation[1], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[2], &OwnerClearDisable, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			
	packTPM2ClearControl(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT8)sessionNumber, (UINT8)OwnerClearDisable);
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_DaLockReset(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			sessionNumber = 0;
		
	ShellConvertStringToUint64( operation[1], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			
	packTPM2DaLockReset(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT8) sessionNumber );
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_HashStart(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT8			rawData[1024];

	UINT64			handleNumber = 0;
	UINT32			hashSeqHandle = 0;
			
	ShellConvertStringToUint64( operation[1], &handleNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	
	packTPM2HashSequenceStart(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg);
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_HashSequenceStart( &packedCmd, &hashSeqHandle ) == TCG_OK ) {

		sCfg.objHandle[handleNumber] = hashSeqHandle;
		
		updateScfgFile( &sCfg, sCfgFile ); 

		return 0;
	}

	return -1;
}

UINT32 TPM2_HashUpdate(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT8			rawData[1024];

	UINT64			handleNumber = 0;
	UINT32			hashSeqHandle = 0;
	UINT64 			dataSize = 0;
		
	ShellConvertStringToUint64( operation[1], &handleNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	//data size
	ShellConvertStringToUint64( operation[3], &dataSize, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading data File------------\n"); 
	readDatFile((UINT8*)&rawData, &dataSize, operation[2]);
		
	DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);
	
	packTPM2HashSequenceUpdate(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT8) handleNumber, (UINT8*) rawData, dataSize);
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_HashComplete(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			handleNumber = 0;
	UINT32			hashSeqHandle = 0;
	UINT16 			dataSize = 0;
	UINT8			hash[256];
		
	ShellConvertStringToUint64( operation[1], &handleNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	//data size
	//ShellConvertStringToUint64( operation[3], &dataSize, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	//Print(L"--------Reading data File------------\n"); 
	//readDatFile((UINT8*)&rawData, &dataSize, operation[2]);
		
	//DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);

	packTPM2HashSequenceComplete( &packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT8) handleNumber );
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_HashSequenceComplete( &packedCmd, hash, &dataSize ) == TCG_OK ) {

		Print(L"Data File: %s\n", operation[2]);
		
		DumpHexValue(L"Hash Data:", (UINT8 *)&hash, dataSize);

		Print(L"--------Writing data File------------\n"); 
		writeDatFile((UINT8*)&hash, (UINT64*)&dataSize, operation[2]);
		Print(L"--------Complete------------\n");

		return 0;
	}
	return -1;
}

UINT32 TPM2_TPM2HMAC(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT8			rawData[1024];

	UINT64			sessionNumber = 0;
	UINT64 			dataSize = 0;
		
	ShellConvertStringToUint64( operation[1], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	//data size
	ShellConvertStringToUint64( operation[3], &dataSize, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading data File------------\n\n"); 
	readDatFile((UINT8*)&rawData, &dataSize, operation[2]);
		
	DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);
		
	packTPM2HMAC(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT8) sessionNumber, (UINT8*) rawData, dataSize);
		
	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_GetCapability(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64 capability;
	UINT64 property; 
	UINT64 propertyCount;
	BOOLEAN verbose = TRUE;

	ShellConvertStringToUint64( operation[1], &capability, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[2], &property, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[3], &propertyCount, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	if ( TPM_20_Get_Capability( (UINT32)capability, (UINT32)property, (UINT32)propertyCount, verbose) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_NVWriteLock(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE iDef;

	UINT64			sessionNumber = 0;
	UINT32			handle0 = 0;
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading iDef File------------\n"); 
	readIdefFile(&iDef, operation[1]);
		
	if (StrniCmp(operation[3], L"PH", 2) == 0) {
		handle0 = TPM_RH_PLATFORM;
	}
	else if (StrniCmp(operation[3], L"SH", 2) == 0) {
		handle0 = TPM_RH_OWNER;
	}
	else {
		handle0 = iDef.publicInfo.nvPublic.nvIndex;
	}

	packTPM2NVWriteLock( &packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &iDef, &sCfg, (UINT8) sessionNumber, handle0 );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_NVChangeAuth(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_NV_DEF_FILE iDef;

	UINT64			sessionNumber = 0;
	UINT64			authNumber = 0;
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	ShellConvertStringToUint64( operation[3], &authNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading iDef File------------\n"); 
	readIdefFile(&iDef, operation[1]);
		
	packTPM2NVChangeAuth( &packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &iDef, &sCfg, (UINT8) sessionNumber, (UINT8) authNumber );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_GetRandom(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT32			hashSeqHandle = 0;
	UINT64 			dataSize = 0;
	UINT8			data[1024];
		
	ShellConvertStringToUint64( operation[1], &dataSize, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	if ( TPM_20_GetRandom( data, (UINT16*)&dataSize ) == TCG_OK ) {
		Print(L"Data File: %s\n", operation[2]);
		
		DumpHexValue(L"Random Data:", (UINT8 *)&data, dataSize);

		Print(L"--------Writing data File------------\n"); 
		writeDatFile((UINT8*)&data, (UINT64*)&dataSize, operation[2]);
		Print(L"--------Complete------------\n"); 
		return 0;
	}

	return -1;
}

UINT32 TPM2_CreatePrimary(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_K_DEF_FILE	kDef;
	UINT8			rawData[1024];

	UINT64			sessionNumber = 0;
	UINT64			handleNumber = 0;
	UINT32			keyHandle = 0;
	UINT64			dataSize = 0;
	UINT16			size = 0;
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	ShellConvertStringToUint64( operation[3], &handleNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
		
	Print(L"--------Reading kDef File------------\n"); 
	readKdefFile(&kDef, operation[1]);
		
	packTPM2CreatePrimary( &packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &kDef, &sCfg, (UINT8) sessionNumber );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	//TPM_20_SendGenericCommand( &packedCmd );
	if ( TPM_20_CreatePrimary( &packedCmd, &keyHandle, rawData, &size ) == TCG_OK ) {

		Print(L"Key Handle: 0x%x\n", keyHandle);
		sCfg.objHandle[handleNumber] = keyHandle;
		updateScfgFile( &sCfg, sCfgFile ); 

		Print(L"Data File: %s\n", operation[3]);
		DumpHexValue(L"Key Public Data:", rawData, size );
		dataSize = size;
		Print(L"--------Writing data File------------\n"); 
		writeDatFile((UINT8*)&rawData, (UINT64*)&dataSize, operation[4]);
		Print(L"--------Complete------------\n"); 
		return 0;
	}

	return -1;
}

UINT32 TPM2_Create(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_K_DEF_FILE			kDef;

	UINT64			sessionNumber = 0;
	UINT64			handleNumber = 0;
	UINT64			dataSize = 0;
	UINT8			dataPublic[1024];
	UINT8			dataPrivate[1024];
	UINT16			sizePublic = 0;
	UINT16			sizePrivate = 0;
		
	ShellConvertStringToUint64( operation[2], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[3], &handleNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	Print(L"--------Reading kDef File------------\n"); 
	readKdefFile(&kDef, operation[1]);
	
	packTPM2Create( &packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &kDef, &sCfg, (UINT8) sessionNumber, (UINT8) handleNumber );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_Create( &packedCmd, dataPublic, &sizePublic, dataPrivate, &sizePrivate ) == TCG_OK ) {

		Print(L"outPrivate File: %s\n", operation[4]);
		DumpHexValue(L"Key Public Data:", dataPrivate, sizePrivate );
		dataSize = sizePrivate;
		Print(L"--------Writing data File------------\n"); 
		writeDatFile((UINT8*)&dataPrivate, (UINT64*)&dataSize, operation[4]);
		Print(L"--------Complete------------\n"); 

		Print(L"outPublic File: %s\n", operation[5]);
		DumpHexValue(L"Key Public Data:", dataPublic, sizePublic );
		dataSize = sizePublic;
		Print(L"--------Writing data File------------\n"); 
		writeDatFile((UINT8*)&dataPublic, (UINT64*)&dataSize, operation[5]);
		Print(L"--------Complete------------\n"); 
		return 0;
	}


	return -1;
}

UINT32 TPM2_LoadExternal(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT8					rawData[1024];

	UINT64			dataSize = 0;
	UINT32			hierarchy = 0;
	UINT64			handleNumber = 0;
	UINT32			objectHandle = 0;
	UINT8			objectName[256];
	UINT16			nameSize = 0;

	if( StrCmp(operation[1], L"PH") == 0 ) {
		hierarchy = TPM_RH_PLATFORM;
	} else if( StrCmp(operation[1], L"SH") == 0 ) {
		hierarchy = TPM_RH_OWNER ;
	} else if( StrCmp(operation[1], L"EH") == 0 ) {
		hierarchy = TPM_RH_ENDORSEMENT;
	} else {
		Print(L"Error: Unknown Hierarchy - Please use PH, SH, or EH\n");
	}

	ShellConvertStringToUint64( operation[3], &handleNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	Print(L"--------Reading data File------------\n"); 
	readDatFile((UINT8*)&rawData, &dataSize, operation[2]);
		
	DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);

	packTPM2LoadExternal(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, hierarchy, NULL, 0, rawData, dataSize );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	//TPM_20_SendGenericCommand( &packedCmd );
	if ( TPM_20_LoadExternal( &packedCmd, &objectHandle, objectName, &nameSize) == TCG_OK ) {

		sCfg.objHandle[handleNumber] = objectHandle;
		
		updateScfgFile( &sCfg, sCfgFile ); 

		Print(L"objectName File: %s\n", operation[4]);
		DumpHexValue(L"objectName Data:", objectName, nameSize );
		dataSize = nameSize;
		Print(L"--------Writing data File------------\n"); 
		writeDatFile((UINT8*)&objectName, (UINT64*)&dataSize, operation[4]);
		Print(L"--------Complete------------\n"); 
		return 0;
	}
	return -1;
}

UINT32 TPM2_Load(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			dataSize = 0;
	UINT64			sessionNumber = 0;
	UINT64			inPrivateSize = 0;
	UINT64			inPublicSize = 0;
	UINT32			hierarchy = 0;
	UINT64			handleNumber = 0;
	UINT32			objectHandle = 0;
	UINT8			objectName[256];
	UINT16			nameSize = 0;
	UINT8			inPrivate[1024];
	UINT8			inPublic[1024];
		
	ShellConvertStringToUint64( operation[3], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[4], &handleNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	
	
		
	Print(L"--------Reading private data file------------\n"); 
	readDatFile((UINT8*)&inPrivate, &inPrivateSize, operation[1]);
		
	DumpHexValue(L"rawData:", (UINT8 *)inPrivate, inPrivateSize);

	Print(L"--------Reading private data file------------\n"); 
	readDatFile((UINT8*)&inPublic, &inPublicSize, operation[2]);
		
	DumpHexValue(L"rawData:", (UINT8 *)inPublic, inPublicSize);

	packTPM2Load(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, inPrivate, inPrivateSize, inPublic, inPublicSize, handleNumber, sessionNumber );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	//TPM_20_SendGenericCommand( &packedCmd );
	if ( TPM_20_LoadExternal( &packedCmd, &objectHandle, objectName, &nameSize) == TCG_OK ) {

		sCfg.objHandle[handleNumber] = objectHandle;
		
		updateScfgFile( &sCfg, sCfgFile ); 

		Print(L"objectName File: %s\n", operation[5]);
		DumpHexValue(L"objectName Data:", objectName, nameSize );
		dataSize = nameSize;
		Print(L"--------Writing data File------------\n"); 
		writeDatFile((UINT8*)&objectName, (UINT64*)&dataSize, operation[5]);
		Print(L"--------Complete------------\n"); 
		return 0;
	}

	return -1;
}

UINT32 TPM2_Execute(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_CDEF_FILE			cDef;

	UINT64			sessionNumber[4] = {0};
	BOOLEAN			sessions = FALSE;
	UINT64			i = 0, j = 0;
	UINT8			responseBuffer[1024];
	UINT16			tag = 0;
	UINT32			responseSize = 0;
	UINT32			handle = 0;
	UINT16			dataRemaining = 0;
	UINT16			paramOffset = 0;
	UINT16			paramSize = 0;
		
	Print(L"--------Reading kDef File------------\n"); 
	readCdefFile(&cDef, operation[1]);
		
	if ( numArgs > 2 ) {
		for ( i = 2; i < numArgs; i++, j++ ) {
			ShellConvertStringToUint64( operation[i], &sessionNumber[j], /*force hex*/ FALSE, /*stop at space*/ TRUE );
		}
		sessions = TRUE;
	}
	packTPM2Execute( &packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &cDef, &sCfg, sessions, sessionNumber );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
	if ( TPM_20_ExecuteCommand( &packedCmd, responseBuffer, &responseSize, &tag) == TCG_OK ) {

		DumpHexValue(L"TPM2 Response:", responseBuffer, responseSize);

		if ( responseSize <= 10 ) {
			return 0;
		}

		//decode and save handles
		if (cDef.OutHandle == 0 ) {			//no handles
			//parameterSize = *(UINT32*)&responseBuffer[10];
			paramOffset = 10;
		} else if (cDef.OutHandle == 1 ) {	//store 1 handle
			handle = *(UINT32*)&responseBuffer[10];
			cDef.handle[cDef.handleIndex] = ChangeEndiannessDWord( handle );
			paramOffset = 14;

		} else if (cDef.OutHandle == 2 ) {	//discard 1 handle
			paramOffset = 14;
		}

		if (tag == TPM_ST_NO_SESSIONS ) {
			//do nothing

		} else if (tag == TPM_ST_SESSIONS ) {
			paramOffset += 4;
		} 

		//decode and save parameters
		for ( i = 0; i < cDef.numResponseParams; i++ ) {

			
			if ( cDef.Rp[i].rpType == PARAM_DATA ) {
				
				paramSize = ChangeEndiannessWord(cDef.Rp[i].rpSize);

				dataRemaining = responseSize - paramOffset; 
				if ( dataRemaining < cDef.Rp[i].rpSize  && dataRemaining > 0 ) {
					cDef.Rp[i].rpSize = dataRemaining;
				}

				if ( cDef.Rp[i].action == SKIP_PARAM ) {
					//throw the data away 
					
				} else if ( cDef.Rp[i].action == REPLACE_PARAM ) {
					ZeroMem(&sCfg.data[cDef.Rp[i].arrayIndex].buffer, T2T_MAX_DATA);
					
					switch (cDef.Rp[i].arrayName) {
						case CONFIG_DIGEST:
							if (cDef.Rp[i].includeSize) {
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer, &paramSize, sizeof(UINT16) );
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer[2], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.digest[cDef.Rp[i].arrayIndex].size = cDef.Rp[i].rpSize + 2;
							} else {
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer, &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.digest[cDef.Rp[i].arrayIndex].size = cDef.Rp[i].rpSize;
							}
							break;
						case CONFIG_KEY:
							if (cDef.Rp[i].includeSize) {
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer, &paramSize, sizeof(UINT16) );
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer.buffer[2], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.key[cDef.Rp[i].arrayIndex].size = cDef.Rp[i].rpSize + 2;
								sCfg.key[cDef.Rp[i].arrayIndex].buffer.size = cDef.Rp[i].rpSize + 2;
							} else {
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer.buffer, &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.key[cDef.Rp[i].arrayIndex].size = cDef.Rp[i].rpSize;
								sCfg.key[cDef.Rp[i].arrayIndex].buffer.size = cDef.Rp[i].rpSize;
							}
							break;
						case CONFIG_AUTH:
							if (cDef.Rp[i].includeSize) {
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer, &paramSize, sizeof(UINT16) );
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer[2], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.authValue[cDef.Rp[i].arrayIndex].size = cDef.Rp[i].rpSize + 2;
							} else {
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer, &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.authValue[cDef.Rp[i].arrayIndex].size = cDef.Rp[i].rpSize;
							}
							break;
						case CONFIG_DATA:
							if (cDef.Rp[i].includeSize) {
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer, &paramSize, sizeof(UINT16) );
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer[2], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.data[cDef.Rp[i].arrayIndex].size = cDef.Rp[i].rpSize + 2;
							} else {
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer, &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.data[cDef.Rp[i].arrayIndex].size = cDef.Rp[i].rpSize;
							}
							break;
						default:
							break;
					}
									
				} else if ( cDef.Rp[i].action == APPEND_PARAM ) {
					//UINT16 paramSize = 0;
					//copy the size in big endian
					paramSize = ChangeEndiannessWord(cDef.Rp[i].rpSize);

					switch (cDef.Rp[i].arrayName) {
						case CONFIG_DIGEST:
							if (cDef.Rp[i].includeSize) {
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer[sCfg.digest[cDef.Rp[i].arrayIndex].size], &paramSize, sizeof(UINT16) );
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer[sCfg.digest[cDef.Rp[i].arrayIndex].size + 2], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.digest[cDef.Rp[i].arrayIndex].size += cDef.Rp[i].rpSize + 2;
							} else {
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer[sCfg.digest[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.digest[cDef.Rp[i].arrayIndex].size += cDef.Rp[i].rpSize;
							}
							break;
						case CONFIG_KEY:
							if (cDef.Rp[i].includeSize) {
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer.buffer[sCfg.key[cDef.Rp[i].arrayIndex].size], &paramSize, sizeof(UINT16) );
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer.buffer[sCfg.key[cDef.Rp[i].arrayIndex].size + 2], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.key[cDef.Rp[i].arrayIndex].size += cDef.Rp[i].rpSize + 2;
								sCfg.key[cDef.Rp[i].arrayIndex].buffer.size += cDef.Rp[i].rpSize + 2;
							} else {
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer.buffer[sCfg.key[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.key[cDef.Rp[i].arrayIndex].size += cDef.Rp[i].rpSize;
								sCfg.key[cDef.Rp[i].arrayIndex].buffer.size += cDef.Rp[i].rpSize;
							}
							break;
						case CONFIG_AUTH:
							if (cDef.Rp[i].includeSize) {
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer[sCfg.authValue[cDef.Rp[i].arrayIndex].size], &paramSize, sizeof(UINT16) );
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer[sCfg.authValue[cDef.Rp[i].arrayIndex].size + 2], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.authValue[cDef.Rp[i].arrayIndex].size += cDef.Rp[i].rpSize + 2;
							} else {
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer[sCfg.authValue[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.authValue[cDef.Rp[i].arrayIndex].size += cDef.Rp[i].rpSize;
							}
							break;
						case CONFIG_DATA:
							if (cDef.Rp[i].includeSize) {
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer[sCfg.data[cDef.Rp[i].arrayIndex].size], &paramSize, sizeof(UINT16) );
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer[sCfg.data[cDef.Rp[i].arrayIndex].size + 2], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.data[cDef.Rp[i].arrayIndex].size += cDef.Rp[i].rpSize + 2;
							} else {
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer[sCfg.data[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], cDef.Rp[i].rpSize );
								sCfg.data[cDef.Rp[i].arrayIndex].size += cDef.Rp[i].rpSize;
							}
							break;
						default:
							break;
					}

				}
				paramOffset += cDef.Rp[i].rpSize;


			} else if ( cDef.Rp[i].rpType == PARAM_TPM2B ) {

				if ( cDef.Rp[i].action == SKIP_PARAM ) {
					//throw the data away for now
					UINT16 paramSize = 0;
					//copy the size in big endian
					CopyMem( &paramSize, &responseBuffer[paramOffset], sizeof(UINT16) );
					paramSize = ChangeEndiannessWord( paramSize );
					paramSize += 2;
					paramOffset += paramSize;

				} else if ( cDef.Rp[i].action == REPLACE_PARAM ) {
					//UINT16 paramSize = 0;
					ZeroMem(&sCfg.data[cDef.Rp[i].arrayIndex].buffer, T2T_MAX_DATA);

					//copy the size in big endian
					CopyMem( &paramSize, &responseBuffer[paramOffset], sizeof(UINT16) );
					paramSize = ChangeEndiannessWord( paramSize );
				
					switch (cDef.Rp[i].arrayName) {
						case CONFIG_DIGEST:
							if (cDef.Rp[i].includeSize) {
								paramSize += 2;
								sCfg.digest[cDef.Rp[i].arrayIndex].size = paramSize;
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer, &responseBuffer[paramOffset], paramSize);
							} else {
								sCfg.digest[cDef.Rp[i].arrayIndex].size = paramSize;
								paramOffset +=2;
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer, &responseBuffer[paramOffset], paramSize );
							}
							break;
						case CONFIG_KEY:
							if (cDef.Rp[i].includeSize) {
								paramSize += 2;
								sCfg.key[cDef.Rp[i].arrayIndex].size = paramSize;
								sCfg.key[cDef.Rp[i].arrayIndex].buffer.size = paramSize;
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer.buffer, &responseBuffer[paramOffset], paramSize);
							} else {
								sCfg.key[cDef.Rp[i].arrayIndex].size = paramSize;
								sCfg.key[cDef.Rp[i].arrayIndex].buffer.size = paramSize;
								paramOffset +=2;
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer.buffer, &responseBuffer[paramOffset], paramSize );
							}
							break;
						case CONFIG_AUTH:
							if (cDef.Rp[i].includeSize) {
								paramSize += 2;
								sCfg.authValue[cDef.Rp[i].arrayIndex].size = paramSize;
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer, &responseBuffer[paramOffset], paramSize);
							} else {
								sCfg.authValue[cDef.Rp[i].arrayIndex].size = paramSize;
								paramOffset +=2;
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer, &responseBuffer[paramOffset], paramSize );
							}
							break;
						case CONFIG_DATA:
							if (cDef.Rp[i].includeSize) {
								paramSize += 2;
								sCfg.data[cDef.Rp[i].arrayIndex].size = paramSize;
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer, &responseBuffer[paramOffset], paramSize);
								
							} else {
								sCfg.data[cDef.Rp[i].arrayIndex].size = paramSize;
								paramOffset +=2;
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer, &responseBuffer[paramOffset], paramSize );
							}
							break;
						default:
							break;
					}
					paramOffset += paramSize;
					
				} else if ( cDef.Rp[i].action == APPEND_PARAM ) {
					//UINT16 paramSize = 0;

					//copy the size in big endian
					CopyMem( &paramSize, &responseBuffer[paramOffset], sizeof(UINT16) );
					paramSize = ChangeEndiannessWord( paramSize );
				
					switch (cDef.Rp[i].arrayName) {
						case CONFIG_DIGEST:
							if (cDef.Rp[i].includeSize) {
								paramSize += 2;
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer[sCfg.digest[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], paramSize );
								sCfg.digest[cDef.Rp[i].arrayIndex].size += paramSize;
							} else {
								
								paramOffset +=2;
								CopyMem( &sCfg.digest[cDef.Rp[i].arrayIndex].buffer[sCfg.digest[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], paramSize );
								sCfg.digest[cDef.Rp[i].arrayIndex].size += paramSize;
							}
							break;
						case CONFIG_KEY:
							if (cDef.Rp[i].includeSize) {
								paramSize += 2;
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer.buffer[sCfg.key[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], paramSize );
								sCfg.key[cDef.Rp[i].arrayIndex].size += paramSize;
								sCfg.key[cDef.Rp[i].arrayIndex].buffer.size += paramSize;
							} else {
								
								paramOffset +=2;
								CopyMem( &sCfg.key[cDef.Rp[i].arrayIndex].buffer.buffer[sCfg.key[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], paramSize );
								sCfg.key[cDef.Rp[i].arrayIndex].size += paramSize;
								sCfg.key[cDef.Rp[i].arrayIndex].buffer.size += paramSize;
							}
							break;
						case CONFIG_AUTH:
							if (cDef.Rp[i].includeSize) {
								paramSize += 2;
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer[sCfg.authValue[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], paramSize );
								sCfg.authValue[cDef.Rp[i].arrayIndex].size += paramSize;
							} else {
								
								paramOffset +=2;
								CopyMem( &sCfg.authValue[cDef.Rp[i].arrayIndex].buffer[sCfg.authValue[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], paramSize );
								sCfg.authValue[cDef.Rp[i].arrayIndex].size += paramSize;
							}
							break;
						case CONFIG_DATA:
							if (cDef.Rp[i].includeSize) {
								paramSize += 2;
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer[sCfg.data[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], paramSize );
								sCfg.data[cDef.Rp[i].arrayIndex].size += paramSize;
							} else {
								
								paramOffset +=2;
								CopyMem( &sCfg.data[cDef.Rp[i].arrayIndex].buffer[sCfg.data[cDef.Rp[i].arrayIndex].size], &responseBuffer[paramOffset], paramSize );
								sCfg.data[cDef.Rp[i].arrayIndex].size += paramSize;
							}
							break;
						default:
							break;
					}
					paramOffset += paramSize;
					
					
				}

			}
		}
		
		

		updateScfgFile( &sCfg, sCfgFile ); 
	}

	return -1;
}

UINT32 TPM2_SaveKey(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	T2T_SOBJ_FILE			sObj;

	UINT64			dataIndexes[4] = {0};
	BOOLEAN			sessions = FALSE;
	UINT64			i = 0, j = 0;
	UINT8			responseBuffer[1024];
	UINT16			tag = 0;
	UINT32			responseSize = 0;
	UINT32			handle = 0;
	UINT16			dataRemaining = 0;
	UINT16			paramOffset = 0;
	UINT16			paramSize = 0;
		
	//Print(L"--------Reading kDef File------------\n"); 
	//readSobjFile(&sObj, operation[1]);
	ZeroMem(&sObj, sizeof(T2T_SOBJ_FILE) );

	if ( numArgs > 1 ) {
		for ( i = 2; i < numArgs; i++, j++ ) {
			ShellConvertStringToUint64( operation[i], &dataIndexes[j], /*force hex*/ FALSE, /*stop at space*/ TRUE );
		}
		sessions = TRUE;
	}

	//name index
	sObj.name.size = sCfg.digest[dataIndexes[0]].size;
	CopyMem( &sObj.name.buffer, &sCfg.digest[dataIndexes[0]].buffer, sCfg.digest[dataIndexes[0]].size );

	//public index
	sObj.keyPublic.size = sCfg.data[dataIndexes[1]].size;
	CopyMem( &sObj.keyPublic.buffer, &sCfg.data[dataIndexes[1]].buffer, sCfg.data[dataIndexes[1]].size );

	if ( numArgs > 4 ) {
		//private index
		sObj.encryptedPrivate.size = sCfg.data[dataIndexes[2]].size;
		CopyMem( &sObj.encryptedPrivate.buffer, &sCfg.data[dataIndexes[2]].buffer, sCfg.data[dataIndexes[2]].size );
	}

	
	updateSobjFile(&sObj, operation[1] );

	return -1;
}

UINT32 TPM2_LoadKey( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			dataSize = 0;
	UINT64			sessionNumber = 0;
	UINT64			inPrivateSize = 0;
	UINT64			inPublicSize = 0;
	UINT32			hierarchy = 0;
	UINT64			parentHandleIDX = 0;
	UINT64			outHandleIDX = 0;
	UINT64			outNameIDX = 0;
	UINT32			objectHandle = 0;
	UINT8			objectName[256];
	UINT16			nameSize = 0;
	UINT8			inPrivate[1024];
	UINT8			inPublic[1024];
	
	
	T2T_SOBJ_FILE			sObj;

	
	ShellConvertStringToUint64( operation[2], &parentHandleIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[3], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[4], &outHandleIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	ZeroMem(&sObj, sizeof(T2T_SOBJ_FILE) );
	Print(L"--------Reading sObj File------------\n"); 
	readSobjFile(&sObj, operation[1]);

	//Print(L"--------Reading private data file------------\n"); 
	//readDatFile((UINT8*)&inPrivate, &inPrivateSize, operation[1]);
		
	DumpHexValue(L"rawData:", (UINT8 *)&sObj.encryptedPrivate.buffer, sObj.encryptedPrivate.size);

	//Print(L"--------Reading private data file------------\n"); 
	//readDatFile((UINT8*)&inPublic, &inPublicSize, operation[2]);
		
	DumpHexValue(L"rawData:", (UINT8 *)&sObj.keyPublic.buffer, sObj.keyPublic.size);

	packTPM2Load(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT8 *)&sObj.encryptedPrivate.buffer, sObj.encryptedPrivate.size, (UINT8 *)&sObj.keyPublic.buffer, sObj.keyPublic.size, parentHandleIDX, sessionNumber );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	//TPM_20_SendGenericCommand( &packedCmd );
	if ( TPM_20_LoadExternal( &packedCmd, &objectHandle, objectName, &nameSize) == TCG_OK ) {

		//if nameIDX was specified we also save the name to a config digest
		if ( numArgs > 6 ) {
			ShellConvertStringToUint64( operation[4], &outNameIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			sCfg.digest[outNameIDX].size = nameSize;
			CopyMem( &sCfg.digest[outNameIDX].buffer, &objectName, nameSize );
		}
		//save the handle to the config file
		sCfg.objHandle[outHandleIDX] = objectHandle;
		updateScfgFile( &sCfg, sCfgFile ); 

		//save the object name to the sObj file
		DumpHexValue(L"objectName Data:", objectName, nameSize );
		sObj.name.size = nameSize;
		CopyMem( &sObj.name.buffer, &objectName, nameSize );
		updateSobjFile(&sObj, operation[1] );
		
		return 0;
	}

	return -1;
}

UINT32 TPM2_LoadPublic( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			dataSize = 0;
	UINT64			sessionNumber = 0;
	UINT64			inPrivateSize = 0;
	UINT64			inPublicSize = 0;
	UINT32			hierarchy = 0;
	UINT64			outHandleIDX = 0;
	UINT64			outNameIDX = 0;
	UINT32			objectHandle = 0;
	UINT8			objectName[256];
	UINT16			nameSize = 0;
	UINT8			inPrivate[1024];
	UINT8			inPublic[1024];
	
	T2T_SOBJ_FILE			sObj;

	if( StrCmp(operation[2], L"PH") == 0 ) {
		hierarchy = TPM_RH_PLATFORM;
	} else if( StrCmp(operation[2], L"SH") == 0 ) {
		hierarchy = TPM_RH_OWNER ;
	} else if( StrCmp(operation[2], L"EH") == 0 ) {
		hierarchy = TPM_RH_ENDORSEMENT;
	} else {
		Print(L"Error: Unknown Hierarchy - Please use PH, SH, or EH\n");
	}

	ShellConvertStringToUint64( operation[3], &outHandleIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	
	ZeroMem(&sObj, sizeof(T2T_SOBJ_FILE) );
	Print(L"--------Reading sObj File------------\n"); 
	readSobjFile(&sObj, operation[1]);
		
	DumpHexValue(L"rawData:", (UINT8 *)&sObj.keyPublic.buffer, sObj.keyPublic.size);

	packTPM2LoadExternal(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, hierarchy, NULL, 0, (UINT8 *)&sObj.keyPublic.buffer, sObj.keyPublic.size );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	//TPM_20_SendGenericCommand( &packedCmd );
	if ( TPM_20_LoadExternal( &packedCmd, &objectHandle, objectName, &nameSize) == TCG_OK ) {

		//if nameIDX was specified we also save the name to a config digest
		if ( numArgs > 5 ) {
			ShellConvertStringToUint64( operation[4], &outNameIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			sCfg.digest[outNameIDX].size = nameSize;
			CopyMem( &sCfg.digest[outNameIDX].buffer, &objectName, nameSize );
		}
		//save the handle to the config file
		sCfg.objHandle[outHandleIDX] = objectHandle;
		updateScfgFile( &sCfg, sCfgFile ); 

		//save the object name to the sObj file
		DumpHexValue(L"objectName Data:", objectName, nameSize );
		sObj.name.size = nameSize;
		CopyMem( &sObj.name.buffer, &objectName, nameSize );
		updateSobjFile(&sObj, operation[1] );
		
	}

	return -1;
}

UINT32 TPM2_LoadTemp( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64			dataSize = 0;
	UINT64			sessionNumber = 0;
	UINT64			inPrivateSize = 0;
	UINT64			inPublicSize = 0;
	UINT32			hierarchy = 0;
	UINT64			outHandleIDX = 0;
	UINT64			outNameIDX = 0;
	UINT32			objectHandle = 0;
	UINT8			objectName[256];
	UINT16			nameSize = 0;
	UINT8			inPrivate[1024];
	UINT8			inPublic[1024];
	
	T2T_SOBJ_FILE			sObj;

	ShellConvertStringToUint64( operation[2], &outHandleIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[3], &outNameIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	
	ZeroMem(&sObj, sizeof(T2T_SOBJ_FILE) );
	Print(L"--------Reading sObj File------------\n"); 
	readSobjFile(&sObj, operation[1]);
	
	DumpHexValue(L"rawData:", (UINT8 *)&sObj.encryptedPrivate.buffer, sObj.encryptedPrivate.size);

	DumpHexValue(L"rawData:", (UINT8 *)&sObj.keyPublic.buffer, sObj.keyPublic.size);

	packTPM2LoadExternal(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, TPM_RH_NULL, (UINT8 *)&sObj.encryptedPrivate.buffer, sObj.encryptedPrivate.size, (UINT8 *)&sObj.keyPublic.buffer, sObj.keyPublic.size );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	//TPM_20_SendGenericCommand( &packedCmd );
	if ( TPM_20_LoadExternal( &packedCmd, &objectHandle, objectName, &nameSize) == TCG_OK ) {

		//if nameIDX was specified we also save the name to a config digest
		if ( numArgs > 4 ) {
			ShellConvertStringToUint64( operation[3], &outNameIDX, /*force hex*/ FALSE, /*stop at space*/ TRUE );
			sCfg.digest[outNameIDX].size = nameSize;
			CopyMem( &sCfg.digest[outNameIDX].buffer, &objectName, nameSize );
		}
		//save the handle to the config file
		sCfg.objHandle[outHandleIDX] = objectHandle;
		updateScfgFile( &sCfg, sCfgFile ); 

		//save the object name to the sObj file
		DumpHexValue(L"objectName Data:", objectName, nameSize );
		sObj.name.size = nameSize;
		CopyMem( &sObj.name.buffer, &objectName, nameSize );
		updateSobjFile(&sObj, operation[1] );
		
	}

	return -1;
}

UINT32 TPM2_HierarchyControl( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64	sessionNumber = 0;
	UINT64	authHandle = 0;
	
	UINT64	enableHierarchy = 0;
	UINT64	hierarchyState = 0;

	ShellConvertStringToUint64( operation[1], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[2], &authHandle, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[3], &enableHierarchy, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[4], &hierarchyState, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	packTPM2HierarchyControl(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT32)authHandle, (UINT32)sessionNumber, (UINT32)enableHierarchy, (UINT8)hierarchyState);

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

//TODO Finish
UINT32 TPM2_Duplicate( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;
	T2P_RP_BUF		cmdResponseBuffer;

	UINT64	sessionNumber = 0;
	UINT64	authHandle = 0;

	ShellConvertStringToUint64( operation[1], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	
	//packTPM2HierarchyControl(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT32)authHandle, (UINT32)sessionNumber, (UINT32)enableHierarchy, (UINT8)hierarchyState);

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_PolicyPCR( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;

	UINT64	sessionNumber = 0;
	UINT64	digestIndex = 0;
	ShellConvertStringToUint64( operation[1], &sessionNumber, /*force hex*/ FALSE, /*stop at space*/ TRUE );
	ShellConvertStringToUint64( operation[2], &digestIndex, /*force hex*/ FALSE, /*stop at space*/ TRUE );

	packTPM2PolicyPCR(&packedCmd, &cmdHeader, &cmdHandles, &cmdAuthArea, &cmdParamArea, &sCfg, (UINT32)sessionNumber, (UINT8)digestIndex );

	DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
	DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
	DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
	DumpHexValue(L"packedCmd.paramBuf.address:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);

	if ( TPM_20_SendGenericCommand( &packedCmd ) == TCG_OK ) {
		return 0;
	}

	return -1;
}

UINT32 TPM2_CalcCpHash (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	//tpm command structures
	T2P_CP_BUF			cmdParamArea;
	T2T_NV_DEF_FILE 	iDef;
	FSR2B_NV_PUBLIC		nvPublic;
	UINT32				commandCode = 0;
	TPM2B_NAME			name;
	UINT16				offset = 0;
	UINT8				CpHash[32];
	cmdParamArea.offset = 0;
	cmdParamArea.headroom = CP_BUF_MAX;
		
	Print(L"--------Reading iDef File------------\n"); 
	readIdefFile(&iDef, operation[2]);
		
	if( StrniCmp(operation[1], L"NvWrite", 7) == 0 ) {
		
		//Pack the command code into the hash buffer first
		commandCode = ChangeEndiannessDWord(TPM_CC_NV_Write);
		CopyMem (&cmdParamArea.buf[cmdParamArea.offset], &commandCode, sizeof(UINT32));
		cmdParamArea.offset += sizeof(UINT32);
		cmdParamArea.headroom -= sizeof(UINT32);

		//get teh name from the handle
		if ( TPM_20_NV_ReadPublic(iDef.publicInfo.nvPublic.nvIndex, 100, &nvPublic, &name, FALSE) == 0 ) {

			//pack the handle name into the hash buffer
			CopyMem (&cmdParamArea.buf[cmdParamArea.offset], &name.name, name.size );
			cmdParamArea.offset += name.size;
			cmdParamArea.headroom -= name.size;

			//two handle names, both the same
			CopyMem (&cmdParamArea.buf[cmdParamArea.offset], &name.name, name.size );
			cmdParamArea.offset += name.size;
			cmdParamArea.headroom -= name.size;

		} else {

			Print(L"Error reading handle name\n");
			return INDEX_DOESNT_EXIST;
		}

		PackFSR2B_DATABUF( &cmdParamArea, &iDef.dataSource, &sCfg);
	
		//pack the offset
		//Print(L"cmdParamArea->offset: %d\n", cmdParamArea->offset);
		offset = ChangeEndiannessWord( iDef.offset );
		CopyMem (&cmdParamArea.buf[cmdParamArea.offset], &offset, sizeof( UINT16 ));
		cmdParamArea.offset += sizeof(UINT16);
		cmdParamArea.headroom -= sizeof(UINT16);

		//Hash the data
		Hash256Target(cmdParamArea.buf, cmdParamArea.offset, CpHash);

	} else if( StrniCmp(operation[1], L"NvUndefineSpecial", 17) == 0 ) {
		Print(L"Not yet supported\n");
		return UNSUPPORTED_OPERATION;
	} else {
		Print(L"Unrecognized Command\n");
		return UNSUPPORTED_OPERATION;
	}

	return 0;
}

UINT32 TPM2_PT2 (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs)
{
	
	
	EFI_STATUS      Status;
	UINT32          RespCode;
	UINT8           AlgIndex;
	UINT8           Index;
	BOOLEAN         Found = FALSE;
	UINT32          NvInfoOffset;
	UINT8			TPM2ProvTable[2048];
	NV_INFO         *IndexInfo;
	PROV2_TABLE		*Prov2Table;
	UINT64			Prove2TableSize = 2048;
	UINT8			TPM2WriteLock[31] = {0x80,0x2,0x0,0x0,0x0,0x1F,0x0,0x0,0x1,0x38,0x1,0x80,0x0,0x1,0x1,0x80,0x0,0x1,0x0,0x0,0x0,0x9,0x40,0x0,0x0,0x9,0x0,0x0,0x0,0x0,0x0};

	//tpm command structures
	T2P_CMD_SGL		packedCmd;
	T2P_CMD_HEADER	cmdHeader;
	T2P_HANDLE_AREA	cmdHandles;
	T2P_AUTHAREA	cmdAuthArea; 
	T2P_CP_BUF		cmdParamArea;

	//For the NvReadPublic
	FSR2B_NV_PUBLIC nvPublic;
	TPM2B_NAME name;

	cmdHandles.handeCount = 0;

	//no auth area
	cmdAuthArea.offset = 0;
	cmdAuthArea.headroom = AUTH_AREA_MAX;
	
	//pack the param area
	cmdParamArea.offset = 0;
	cmdParamArea.headroom = CP_BUF_MAX;

	packedCmd.header.size = 0;
	packedCmd.header.address = NULL;
	packedCmd.handles.size = 0;
	packedCmd.handles.address = NULL;
	packedCmd.authArea.size = 0;
	packedCmd.authArea.address = NULL;
	packedCmd.paramBuf.size = 0;
	packedCmd.paramBuf.address = NULL;

	//Read file
	Print(L"--------Reading TPM2 Prov Table------------\n"); 
	readDatFile((UINT8*)TPM2ProvTable, &Prove2TableSize, operation[1]);

	Prov2Table = TPM2ProvTable;

	if (Prov2Table->NumAlgs == 0) {
		return 0;
	}

	//
	//find an algorithm on disc and check to see if the TPM2 supports it
	//
	for (AlgIndex = 0; (!Found && AlgIndex < Prov2Table->NumAlgs); AlgIndex++) {
		/*
		Status = Tpm20SendCommand (
					Prov2Table->AlgParams[AlgIndex].SetPhPolSize,
					(UINT8 *)ProvisionBuffer + Prov2Table->AlgParams[AlgIndex].SetPhPolOffset,
					&RespCode
					);
*/
		packedCmd.paramBuf.size = Prov2Table->AlgParams[AlgIndex].SetPhPolSize;
		packedCmd.paramBuf.address = (UINT8 *)TPM2ProvTable + Prov2Table->AlgParams[AlgIndex].SetPhPolOffset;

		//DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
		//DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
		//DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
		DumpHexValue(L"Command:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
		Status = TPM_20_SendGenericCommand( &packedCmd );

		if ( Status == EFI_SUCCESS ) { // then stop looking and use this algorithm
			Found = TRUE;
			break;
		}
	}
  
	if (AlgIndex == Prov2Table->NumAlgs) {
		return 0; 
	}

	if (Prov2Table->AlgParams[AlgIndex].NumIndexes == 0) {
		return 0;
	}

	//
	//Get a pointer to the begining of the Nv Info structures
	//

	NvInfoOffset = Prov2Table->AlgParams[AlgIndex].ParamsOffset;
  
	for (Index = 0; Index < Prov2Table->AlgParams[AlgIndex].NumIndexes; Index++) {
		IndexInfo = (VOID *)((UINT8 *)TPM2ProvTable + NvInfoOffset);

		if (TPM_20_NV_ReadPublic(IndexInfo->NvIndex, 100, &nvPublic, &name, TRUE) != 0) { //!Tpm2IndexExist (IndexInfo->NvIndex)
			 /*  
			Status = Tpm20SendCommand (
						IndexInfo->CreateCmdSize,
						(UINT8 *)ProvisionBuffer + IndexInfo->CreateCmdOffset,
						&RespCode
						);
*/
			packedCmd.paramBuf.size = IndexInfo->CreateCmdSize;
			packedCmd.paramBuf.address = (UINT8 *)TPM2ProvTable + IndexInfo->CreateCmdOffset;

			//DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
			//DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
			//DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
			DumpHexValue(L"Command:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
			Status = TPM_20_SendGenericCommand( &packedCmd );
			if (Status != EFI_SUCCESS) { // then stop looking and use this algorithm
				break;
			}

			if (IndexInfo->bWrite) {
               /*
				Status = Tpm20SendCommand (
							IndexInfo->WriteCmdSize,
							(UINT8 *)ProvisionBuffer + IndexInfo->WriteCmdOffset,
							&RespCode
							);
							*/

				packedCmd.paramBuf.size = IndexInfo->WriteCmdSize;
				packedCmd.paramBuf.address = (UINT8 *)TPM2ProvTable + IndexInfo->WriteCmdOffset;

				//DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
				//DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
				//DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
				DumpHexValue(L"Command:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
				Status = TPM_20_SendGenericCommand( &packedCmd );
				if (Status != EFI_SUCCESS) { // then stop looking and use this algorithm
					break;
				}

				//      
				//Write-Protect the index if required, but only if write was successful
				//
				if ((Status == EFI_SUCCESS) && (IndexInfo->bWriteProtect)) {
		//			Tpm2WriteLock (IndexInfo->NvIndex); 
					UINT32 writeLockIndex = ChangeEndiannessDWord(IndexInfo->NvIndex);
					CopyMem(&TPM2WriteLock[10], &writeLockIndex, sizeof(UINT32));
					CopyMem(&TPM2WriteLock[14], &writeLockIndex, sizeof(UINT32));
					packedCmd.paramBuf.size = 0x1F;
					packedCmd.paramBuf.address = TPM2WriteLock;

					//DumpHexValue(L"packedCmd.header.address:", (UINT8 *)packedCmd.header.address, packedCmd.header.size);
					//DumpHexValue(L"packedCmd.handles.address:", (UINT8 *)packedCmd.handles.address, packedCmd.handles.size);
					//DumpHexValue(L"packedCmd.authArea.address:", (UINT8 *)packedCmd.authArea.address, packedCmd.authArea.size);
					DumpHexValue(L"Command:", (UINT8 *)packedCmd.paramBuf.address, packedCmd.paramBuf.size);
		
					Status = TPM_20_SendGenericCommand( &packedCmd );
					if (Status != EFI_SUCCESS) {
						break;
					}
				} 
			}
      
		} 
		NvInfoOffset += Prov2Table->AlgParams[AlgIndex].NvInfoSize;  
	} 



	return 0;
}